# LaraValidator Docs - Brasil
_Validação de documentos do Brasil usando Laravel 5.*_

[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/geekcom/validator-docs/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/geekcom/validator-docs/?branch=master)
[![Total Downloads](https://poser.pugx.org/geekcom/validator-docs/downloads)](https://packagist.org/packages/geekcom/validator-docs)
[![License](https://poser.pugx.org/geekcom/validator-docs/license)](https://packagist.org/packages/geekcom/validator-docs)

Biblioteca Laravel para validação de CPF, CNPJ, CPF/CNPJ (quando salvos no mesmo atributo), CNH, PIS/PASEP/NIT/NIS e Título de Eleitor.

## Instalação

No arquivo `composer.json`, adicione validator-docs como dependência do seu projeto:

```
"require": {
    "geekcom/validator-docs" : "1.*"
 },
```

Depois execute:

```
composer install
```

Ou simplesmente execute o comando:

```
composer require geekcom/validator-docs
```

Após a instalação, adicione ao arquivo `config/app.php` ao array `providers` a seguinte linha:

```php
geekcom\ValidatorDocs\ValidatorProvider::class
```

----------------------------------------------------------------------------------------------------------------------------

## Como usar - Validações disponíveis

Agora, você terá os métodos de validação validator docs Brasil disponíveis.

* **cpf** - Verifica se um CPF é valido.

```php
$this->validate($request, [
    'cpf' => 'required|cpf',
]);
```

* **cnpj** - Verifica se um CNPJ é valido.

```php
$this->validate($request, [
    'cnpj' => 'required|cnpj',
]);
```

* **cnh** - Verifica se uma CNH (Carteira Nacional de Habilitação) é válida.

```php
$this->validate($request, [
    'cnh' => 'required|cnh',
]);
```

* **titulo_eleitor** - Verifica se um Título de Eleitor é válido.

```php
$this->validate($request, [
    'titulo_eleitor' => 'required|titulo_eleitor',
]);
```

* **cpf_cnpj** - Verifica se um CPF ou CNPJ é válido.

```php
$this->validate($request, [
    'cpf_cnpj' => 'required|cpf_cnpj',
]);
```

* **nis** - Verifica se um PIS/PASEP/NIT/NIS é válido.

```php
$this->validate($request, [
    'nis' => 'required|nis',
]);
```

* **formato_cnpj** - Verifica se o formato de um CNPJ é válida. ( 99.999.999/9999-99 )

```php
$this->validate($request, [
    'formato_cnpj' => 'required|formato_cnpj',
]);
```

* **formato_cpf** - Verifica se o formato de um CPF é válido. ( 999.999.999-99 )

```php
$this->validate($request, [
    'formato_cpf' => 'required|formato_cpf',
]);
```

* **formato_cpf_cnpj** - Verifica se o formato de um CPF ou um CNPJ é válido. ( 999.999.999-99 ) ou ( 99.999.999/9999-99 )

```php
$this->validate($request, [
    'formato_cpf_cnpj' => 'required|formato_cpf_cnpj',
]);
```

* **formato_nis** - Verifica se o formato de um PIS/PASEP/NIT/NIS é válido. ( 999.99999-99.9 )

```php
$this->validate($request, [
    'formato_nis' => 'required|formato_nis',
]);
```
----------------------------------------------------------------------------------------------------------------------------

## Combinando validação e formato

No exemplo abaixo, fazemos um teste onde verificamos a formatação e a validade de um CPF ou CNPJ, para os casos onde a informação deva ser salva em um mesmo atributo:

```php
$this->validate($request, [
    'cpf_or_cnpj' => 'formato_cpf_cnpj|cpf_cnpj',
]);
```

----------------------------------------------------------------------------------------------------------------------------

## Exemplo de uso em um controller

Método de validação de exemplo em um controller com todas as possibilidades de validação

```php
public function store(Request $request)
{
    $data = $request->all();

    $this->validate($request, [
        'cpf' => 'required|cpf',
        'cnpj' => 'required|cnpj',
        'cnh' => 'required|cnh',
        'titulo_eleitor' => 'required|titulo_eleitor',
        'nis' => 'required|nis',
    ]);

    dd($data);
}
```

----------------------------------------------------------------------------------------------------------------------------

## Geradores de documentos para testes

* **CNH** - http://4devs.com.br/gerador_de_cnh
* **TÍTULO ELEITORAL** - http://4devs.com.br/gerador_de_titulo_de_eleitor
* **CNPJ** - http://www.geradorcnpj.com/
* **CPF** - http://geradordecpf.org
* **NIS** - https://www.4devs.com.br/gerador_de_pis_pasep

Fique a vontade para contribuir fazendo um fork.

Caso tenha alguma dúvida ou encontre algm bug, abra uma [issue](https://github.com/geekcom/validator-docs/issues) ou pesquise por issues antigas.